/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.lib.util.ResourceUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;
import net.minecraft.class_2319;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class BackendArgument
implements ArgumentType<Backend> {
    private static final List<String> EXAMPLES = List.of("off", "flywheel:off", "instancing");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_BACKEND = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"argument.flywheel_backend.id.unknown", (Object[])new Object[]{arg}));
    public static final BackendArgument INSTANCE = new BackendArgument();
    public static final class_2319<BackendArgument> INFO = class_2319.method_41999(() -> INSTANCE);

    public Backend parse(StringReader reader) throws CommandSyntaxException {
        class_2960 id = ResourceUtil.readFlywheelDefault(reader);
        Backend backend = Backend.REGISTRY.get(id);
        if (backend == null) {
            throw ERROR_UNKNOWN_BACKEND.createWithContext((ImmutableStringReader)reader, (Object)id.toString());
        }
        return backend;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String input = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (class_2960 id : Backend.REGISTRY.getAllIds()) {
            String idStr = id.toString();
            if (!class_2172.method_27136((String)input, (String)idStr) && !class_2172.method_27136((String)input, (String)id.method_12832())) continue;
            builder.suggest(idStr);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

